<?php
/**
 * Reformer for Elementor
 * Customizable contact form for Elementor editor
 * Exclusively on https://1.envato.market/reformer-elementor
 *
 * @encoding        UTF-8
 * @version         1.0.2
 * @copyright       (C) 2018 - 2021 Merkulove ( https://merkulov.design/ ). All rights reserved.
 * @license         Envato License https://1.envato.market/KYbje
 * @contributors    Nemirovskiy Vitaliy (nemirovskiyvitaliy@gmail.com), Dmitry Merkulov (dmitry@merkulov.design), Cherviakov Vlad (vladchervjakov@gmail.com)
 * @support         help@merkulov.design
 **/

namespace Merkulove\ReformerElementor;

use Merkulove\ReformerElementor\Unity\Plugin;

/** Exit if accessed directly. */
if ( ! defined( 'ABSPATH' ) ) {
    header( 'Status: 403 Forbidden' );
    header( 'HTTP/1.1 403 Forbidden' );
    exit;
}

/**
 * SINGLETON: The class used to implement admin styles enqueueing.
 *
 * @since 1.0.0
 *
 **/
final class AdminStyles {

    /**
     * The one true AdminStyles.
     *
     * @var AdminStyles
     * @since 1.0.0
     **/
    private static $instance;

    /**
     * Sets up a new AdminStyles instance.
     *
     * @since 1.0.0
     * @access public
     **/
    private function __construct() {

        /** Add admin styles. */
        add_action( 'admin_enqueue_scripts', [ $this, 'admin_styles' ] );

    }

    /**
     * Add CSS for admin area.
     *
     * @since   1.0.0
     * @return void
     **/
    public function admin_styles() {

        /** ReFormer Settings Page. */
        $this->settings_styles();

        /** Edit ReFormer page. */
        $this->edit_styles();
    }

    /**
     * Styles for edit ReFormer page.
     *
     * @since   1.0.0
     * @return void
     **/
    private function edit_styles() {

        /** Work only on Edit ReFormer page. */
        $screen = get_current_screen();
        if ( null === $screen ) { return; }
        if ( 'mdp_address_book_cpt' !== $screen->id ) { return; }

        wp_enqueue_style(
            'merkulov-ui',
               Plugin::get_url() . 'src/Merkulove/Unity/assets/css/merkulov-ui' . Plugin::get_suffix() . '.css',
                   [], Plugin::get_version()
        );
    }


    /**
     * Styles for Plugin Settings page.
     *
     * @since   1.0.0
     * @return void
     **/
    private function settings_styles() {

        /** Work only on Plugin Settings Page. */
        $screen = get_current_screen();
        if ( null === $screen ) { return; }
        if ( $screen->base !== 'mdp_reformer_sub_page_mdp_reformer_elementor_settings' ) { return; }

        wp_enqueue_style(
            'merkulov-ui',
               Plugin::get_url() . 'src/Merkulove/Unity/assets/css/merkulov-ui' . Plugin::get_suffix() . '.css',
                   [], Plugin::get_version()
        );


    }

    /**
     * Main AdminStyles Instance.
     *
     * Insures that only one instance of AdminStyles exists in memory at any one time.
     *
     * @static
     * @since 1.0.0
     *
     * @return AdminStyles
     **/
    public static function get_instance() {

        if ( ! isset( self::$instance ) && ! ( self::$instance instanceof self ) ) {

            self::$instance = new self;

        }

        return self::$instance;

    }

} // End Class AdminStyles.
