<?php
/**
 * Reformer for Elementor
 * Customizable contact form for Elementor editor
 * Exclusively on https://1.envato.market/reformer-elementor
 *
 * @encoding        UTF-8
 * @version         1.0.2
 * @copyright       (C) 2018 - 2021 Merkulove ( https://merkulov.design/ ). All rights reserved.
 * @license         Envato License https://1.envato.market/KYbje
 * @contributors    Nemirovskiy Vitaliy (nemirovskiyvitaliy@gmail.com), Dmitry Merkulov (dmitry@merkulov.design), Cherviakov Vlad (vladchervjakov@gmail.com)
 * @support         help@merkulov.design
 **/

namespace Merkulove\ReformerElementor;

use Merkulove\ReformerElementor\Unity\Plugin;
use Merkulove\ReformerElementor\Unity\Settings;
use Merkulove\ReformerElementor\Unity\TabGeneral;

/** Exit if accessed directly. */
if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit;
}

/**
 * SINGLETON: Settings class used to modify default plugin settings.
 *
 * @since 1.0.0
 *
 **/
final class Config {

	/**
	 * The one true Settings.
	 *
     * @since 1.0.0
     * @access private
	 * @var Config
	 **/
	private static $instance;

    /**
     * Prepare plugin settings by modifying the default one.
     *
     * @since 1.0.0
     * @access public
     *
     * @return void
     **/
    public function prepare_settings() {

        /** Get default plugin settings. */
        $tabs = Plugin::get_tabs();

        $offset = 0;
        $tabs = array_slice( $tabs, 0, $offset, true ) +
            ['telegram_bot_api' => [
                'enabled'       => true,
                'class'         => TabGeneral::class, // Handler
                'label'         => esc_html__( 'Telegram bot api', 'reformer-elementor' ),
                'title'         => esc_html__( 'Telegram bot api', 'reformer-elementor' ),
                'show_title'    => true,
                'icon'          => 'code', // Icon for tab
                'fields'        => []
            ] ] +
            array_slice( $tabs, $offset, NULL, true );

        $tabs['telegram_bot_api']['fields']['telegram_bot_token'] = [
            'type' => 'text',
            'label' => esc_html__( 'Telegram bot token', 'reformer-elementor' ),
            'show_label' => true,
            'placeholder' => esc_html__( 'Token', 'reformer-elementor' ),
            'description' => wp_kses_post( 'Set your telegram bot token. Visit <a href="https://core.telegram.org/bots#6-botfather" target="_blank">Online Documentation</a> for more details.' ),
            'show_description' => true,
            'default' => '',
            'attr' => [
                'class' => 'mdp-test-class',
                'maxlength' => '4500'
            ]
        ];

        /** Special config for Elementor & WPBakery plugins. */
        unset( $tabs['general'] );

        /** Set updated tabs. */
        Plugin::set_tabs( $tabs );

        /** Refresh settings. */
        Settings::get_instance()->get_options();

    }

	/**
	 * Main Settings Instance.
	 * Insures that only one instance of Settings exists in memory at any one time.
	 *
	 * @static
     * @since 1.0.0
     * @access public
     *
	 * @return Config
	 **/
	public static function get_instance() {

		if ( ! isset( self::$instance ) && ! ( self::$instance instanceof self ) ) {

			self::$instance = new self;

		}

		return self::$instance;

	}

}
