<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @package WordPress
 * @subpackage Abolire
 * @since Abolire 1.0
 */
/*
*Template Name: 404 Page
*/
get_header();


$style = '';
$bg_image = abolire_get_config('404_bg_image');
if( isset($bg_image['url']) && !empty($bg_image['url']) ) {
    $style = 'style="background-image:url('. $bg_image['url'] .');"';
}
?>

<section class="page-404" <?php echo trim($style); ?>>
	<div id="main-container" class="inner">
		<div id="main-content" class="main-page">
			<section class="error-404 not-found clearfix text-center">
				<div class="container">
					<div class="row flex-middle-sm">
						<div class="col-md-12 col-xs-12">
							<div class="slogan">					
								<h3 class="text-extra-large"><?php echo esc_html__('404','abolire') ?></h3>
								<?php
								$title_404 = abolire_get_config('404_title', 'Oops Page Not Found');
								if( !empty($title_404) ) { ?>
									<h4 class="sub-title"><?php echo esc_html($title_404); ?></h4>
								<?php } ?>
							</div>
							<div class="page-content">
								<div class="description">
									<?php echo esc_html(abolire_get_config('404_description', 'It looks like nothing was found at this location. Maybe try again?')); ?>									
								</div>
							</div><!-- .page-content -->
						</div>
					</div>
				</div>
			</section><!-- .error-404 -->
		</div><!-- .content-area -->
	</div>
</section>
<?php get_footer(); ?>