<?php

// Apartment Archive settings
function abolire_apartment_redux_config($sections, $sidebars, $columns) {
    
    $sections[] = array(
        'icon' => 'el el-website',
        'title' => esc_html__('Apartment Settings', 'abolire'),
        'fields' => array(
            array(
                'id' => 'apartments_breadcrumb_setting',
                'icon' => true,
                'type' => 'info',
                'raw' => '<h3 style="margin: 0;"> '.esc_html__('Breadcrumbs Setting', 'abolire').'</h3>',
            ),
            array(
                'id' => 'apartments_breadcrumbs',
                'type' => 'switch',
                'title' => esc_html__('Breadcrumbs', 'abolire'),
                'default' => 1
            ),
            array(
                'title' => esc_html__('Breadcrumbs Background Color', 'abolire'),
                'subtitle' => '<em>'.esc_html__('The breadcrumbs background color of the site.', 'abolire').'</em>',
                'id' => 'apartments_breadcrumb_color',
                'type' => 'color',
                'transparent' => false,
            ),
            array(
                'id' => 'apartments_breadcrumb_image',
                'type' => 'media',
                'title' => esc_html__('Breadcrumbs Background', 'abolire'),
                'subtitle' => esc_html__('Upload a .jpg or .png image that will be your breadcrumbs.', 'abolire'),
            ),
        )
    );
    // Archive settings
    $sections[] = array(
        'title' => esc_html__('Apartments Archives', 'abolire'),
        'subsection' => true,
        'fields' => array(
            array(
                'id' => 'apartments_general_setting',
                'icon' => true,
                'type' => 'info',
                'raw' => '<h3 style="margin: 0;"> '.esc_html__('General Setting', 'abolire').'</h3>',
            ),
            array(
                'id' => 'apartments_style',
                'type' => 'select',
                'title' => esc_html__('Apartment Style', 'abolire'),
                'options' => array(
                    '' => esc_html__('Default', 'abolire'),
                    'style1' => esc_html__('Style 1', 'abolire'),
                    'style2' => esc_html__('Style 2', 'abolire'),
                ),
                'default' => ''
            ),
            array(
                'id' => 'apartments_columns',
                'type' => 'select',
                'title' => esc_html__('Apartment Columns', 'abolire'),
                'options' => $columns,
                'default' => 3,
                'required' => array('apartments_display_mode', '=', array('grid'))
            ),
            array(
                'id' => 'number_apartments_per_page',
                'type' => 'text',
                'title' => esc_html__('Number of Apartments Per Page', 'abolire'),
                'default' => 12,
                'min' => '1',
                'step' => '1',
                'max' => '100',
                'type' => 'slider'
            ),
            array(
                'id' => 'apartments_sidebar_setting',
                'icon' => true,
                'type' => 'info',
                'raw' => '<h3 style="margin: 0;"> '.esc_html__('Sidebar Setting', 'abolire').'</h3>',
            ),
            array(
                'id' => 'apartments_fullwidth',
                'type' => 'switch',
                'title' => esc_html__('Is Full Width?', 'abolire'),
                'default' => false
            ),
            array(
                'id' => 'apartments_layout',
                'type' => 'image_select',
                'compiler' => true,
                'title' => esc_html__('Archive Apartment Layout', 'abolire'),
                'subtitle' => esc_html__('Select the layout you want to apply on your archive apartment page.', 'abolire'),
                'options' => array(
                    'main' => array(
                        'title' => esc_html__('Main Content', 'abolire'),
                        'alt' => esc_html__('Main Content', 'abolire'),
                        'img' => get_template_directory_uri() . '/inc/assets/images/screen1.png'
                    ),
                    'left-main' => array(
                        'title' => esc_html__('Left Sidebar - Main Content', 'abolire'),
                        'alt' => esc_html__('Left Sidebar - Main Content', 'abolire'),
                        'img' => get_template_directory_uri() . '/inc/assets/images/screen2.png'
                    ),
                    'main-right' => array(
                        'title' => esc_html__('Main Content - Right Sidebar', 'abolire'),
                        'alt' => esc_html__('Main Content - Right Sidebar', 'abolire'),
                        'img' => get_template_directory_uri() . '/inc/assets/images/screen3.png'
                    ),
                ),
                'default' => 'main-right'
            ),
            array(
                'id' => 'apartments_left_sidebar',
                'type' => 'select',
                'title' => esc_html__('Archive Left Sidebar', 'abolire'),
                'subtitle' => esc_html__('Choose a sidebar for left sidebar.', 'abolire'),
                'options' => $sidebars
            ),
            array(
                'id' => 'apartments_right_sidebar',
                'type' => 'select',
                'title' => esc_html__('Archive Right Sidebar', 'abolire'),
                'subtitle' => esc_html__('Choose a sidebar for right sidebar.', 'abolire'),
                'options' => $sidebars
            ),
        )
    );
    
    
    // Apartment Page
    $sections[] = array(
        'title' => esc_html__('Apartment Single', 'abolire'),
        'subsection' => true,
        'fields' => array(
            array(
                'id' => 'apartment_general_setting',
                'icon' => true,
                'type' => 'info',
                'raw' => '<h3 style="margin: 0;"> '.esc_html__('General Setting', 'abolire').'</h3>',
            ),
            array(
                'id' => 'apartment_fullwidth',
                'type' => 'switch',
                'title' => esc_html__('Is Full Width?', 'abolire'),
                'default' => false
            ),
            array(
                'id' => 'show_apartment_recent',
                'type' => 'switch',
                'title' => esc_html__('Show Recent Apartments', 'abolire'),
                'default' => 1
            ),
            array(
                'id' => 'number_apartment_recent',
                'type' => 'text',
                'title' => esc_html__('Number of related posts to show', 'abolire'),
                'required' => array('show_apartment_recent', '=', '1'),
                'default' => 3,
                'min' => '1',
                'step' => '1',
                'max' => '20',
                'type' => 'slider'
            ),
            array(
                'id' => 'recent_apartment_columns',
                'type' => 'select',
                'title' => esc_html__('Recent Apartments Columns', 'abolire'),
                'required' => array('show_apartment_recent', '=', '1'),
                'options' => $columns,
                'default' => 3
            ),
            array(
                'id' => 'apartment_sidebar_setting',
                'icon' => true,
                'type' => 'info',
                'raw' => '<h3 style="margin: 0;"> '.esc_html__('Sidebar Setting', 'abolire').'</h3>',
            ),
            array(
                'id' => 'apartment_layout',
                'type' => 'image_select',
                'compiler' => true,
                'title' => esc_html__('Single Apartment Sidebar Layout', 'abolire'),
                'subtitle' => esc_html__('Select the layout you want to apply on your Single Apartment Page.', 'abolire'),
                'options' => array(
                	'main' => array(
                        'title' => esc_html__('Main Content', 'abolire'),
                        'alt' => esc_html__('Main Content', 'abolire'),
                        'img' => get_template_directory_uri() . '/inc/assets/images/screen1.png'
                    ),
                    'left-main' => array(
                        'title' => esc_html__('Left - Main Sidebar', 'abolire'),
                        'alt' => esc_html__('Left - Main Sidebar', 'abolire'),
                        'img' => get_template_directory_uri() . '/inc/assets/images/screen2.png'
                    ),
                    'main-right' => array(
                        'title' => esc_html__('Main - Right Sidebar', 'abolire'),
                        'alt' => esc_html__('Main - Right Sidebar', 'abolire'),
                        'img' => get_template_directory_uri() . '/inc/assets/images/screen3.png'
                    ),
                ),
                'default' => 'main-right'
            ),
            array(
                'id' => 'apartment_left_sidebar',
                'type' => 'select',
                'title' => esc_html__('Archive Left Sidebar', 'abolire'),
                'subtitle' => esc_html__('Choose a sidebar for left sidebar.', 'abolire'),
                'options' => $sidebars
            ),
            array(
                'id' => 'apartment_right_sidebar',
                'type' => 'select',
                'title' => esc_html__('Archive Right Sidebar', 'abolire'),
                'subtitle' => esc_html__('Choose a sidebar for right sidebar.', 'abolire'),
                'options' => $sidebars
            ),

        )
    );

    return $sections;
}
add_filter( 'abolire_redux_framwork_configs', 'abolire_apartment_redux_config', 30, 3 );