<?php

//namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Abolire_Elementor_Search_Form extends Elementor\Widget_Base {

	public function get_name() {
        return 'apus_element_search_form';
    }

	public function get_title() {
        return esc_html__( 'Apus Header Search Form', 'abolire' );
    }
    
	public function get_categories() {
        return [ 'abolire-header-elements' ];
    }

	protected function _register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'Content', 'abolire' ),
                'tab' => Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        
        $this->add_control(
            'show_icon',
            [
                'label' => esc_html__( 'Show Icon', 'abolire' ),
                'type' => Elementor\Controls_Manager::SWITCHER,
                'default' => '',
                'label_on' => esc_html__( 'Show', 'abolire' ),
                'label_off' => esc_html__( 'Hide', 'abolire' ),
            ]
        );

        $this->add_control(
            'show_text',
            [
                'label' => esc_html__( 'Show text Search', 'abolire' ),
                'type' => Elementor\Controls_Manager::SWITCHER,
                'default' => 'yes',
                'label_on' => esc_html__( 'Show', 'abolire' ),
                'label_off' => esc_html__( 'Hide', 'abolire' ),
            ]
        );
        $this->add_control(
            'ali',
            [
                'label' => esc_html__( 'Align Content Search', 'abolire' ),
                'type' => Elementor\Controls_Manager::SELECT,
                'options' => array(
                    'ali-left' => esc_html__('Left ', 'abolire'),
                    'ali-right' => esc_html__('Right ', 'abolire'),
                ),
                'default' => 'ali-left',
            ]
        );
   		$this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'abolire' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'abolire' ),
            ]
        );

        $this->end_controls_section();
    }

	protected function render() {
        $settings = $this->get_settings();

        extract( $settings );
        ?>
        <div class="apus-search-form apus-search-form-style1 <?php echo esc_attr($el_class.' '.$ali); ?>">             
            <a href="javascript:void(0);" class="btn-search-icon"><i class="flaticon-search"></i></a>
            <div class="inner-search">
                <form action="<?php echo esc_url( home_url( '/' ) ); ?>" method="get">
                    
                    <div class="main-search">
                        <input type="text" placeholder="<?php esc_attr_e( 'What do you need?', 'abolire' ); ?>" name="s" class="apus-search form-control" autocomplete="off"/>
                    </div>
                    <input type="hidden" name="post_type" value="post">
                    
                    <button type="submit" class="btn btn-search-icon <?php echo esc_attr(($show_icon && !$show_text)?'st_small':''); ?>"><?php if($show_icon){ ?><i class="flaticon-search"></i><?php } ?><?php if($show_text){ ?><span class="text"><?php esc_html_e('Search', 'abolire'); ?></span><?php } ?></button>
                </form>
            </div>
        </div>
        <?php
    }

}

Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Abolire_Elementor_Search_Form );