<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Abolire_Elementor_Agents extends Widget_Base {

	public function get_name() {
        return 'apus_element_agents';
    }

	public function get_title() {
        return esc_html__( 'Apus Agents', 'abolire' );
    }

    public function get_icon() {
        return 'fa fa-users';
    }

	public function get_categories() {
        return [ 'abolire-elements' ];
    }

	protected function _register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'Agent', 'abolire' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new Repeater();

        $this->add_control(
            'name', [
                'label' => esc_html__( 'Name', 'abolire' ),
                'type' => Controls_Manager::TEXT,                
                'placeholder' => esc_html__( 'Member Name' , 'abolire' ),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'job', [
                'label' => esc_html__( 'Job', 'abolire' ),
                'type' => Controls_Manager::TEXT,                
                'placeholder' => esc_html__( 'Member Job' , 'abolire' ),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'description', [
                'label' => esc_html__( 'Description', 'abolire' ),
                'type' => Controls_Manager::TEXTAREA,                
                'label_block' => true,
            ]
        );

        $this->add_control(
            'email', [
                'label' => esc_html__( 'Email', 'abolire' ),
                'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'info@mywebsite.com' , 'abolire' ),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'phone', [
                'label' => esc_html__( 'Phone', 'abolire' ),
                'type' => Controls_Manager::TEXT,                
                'placeholder' => esc_html__( '0123456789', 'abolire' ),
                'label_block' => true,
            ]
        );
        
        $this->add_control(
            'img_src',
            [
                'name' => 'image',
                'label' => esc_html__( 'Image', 'abolire' ),
                'type' => Controls_Manager::MEDIA,
                'placeholder'   => esc_html__( 'Upload Image Here', 'abolire' ),
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'title', [
                'label' => esc_html__( 'Social Title', 'abolire' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'Social Title' , 'abolire' ),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'link',
            [
                'label' => esc_html__( 'Social Link', 'abolire' ),
                'type' => Controls_Manager::TEXT,
                'input_type' => 'url',
                'placeholder' => esc_html__( 'Enter your social link here', 'abolire' ),
            ]
        );

        $repeater->add_control(
            'icon',
            [
                'label' => esc_html__( 'Social Icon', 'abolire' ),
                'type' => Controls_Manager::ICON,
            ]
        );

        $this->add_control(
            'socials',
            [
                'label' => esc_html__( 'Socials', 'abolire' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );

   		$this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'abolire' ),
                'type'          => Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'abolire' ),
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'section_title_style',
            [
                'label' => esc_html__( 'Title', 'abolire' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__( 'Border Hover Color', 'abolire' ),
                'type' => Controls_Manager::COLOR,
                'scheme' => [
                    'type' => \Elementor\Core\Schemes\Color::get_type(),
                    'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'selectors' => [
                    // Stronger selector to avoid section style from overwriting
                    '{{WRAPPER}} .widget-team:hover' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

    }

	protected function render() {
        $settings = $this->get_settings();

        extract( $settings );

        ?>
        <div class="widget-team <?php echo esc_attr($el_class); ?>">

            <?php
                if ( !empty($settings['img_src']['id']) ) {
            ?>
                <div class="team-image">
                    <?php echo abolire_get_attachment_thumbnail($settings['img_src']['id'], 'full'); ?>
                    
                    <a class="team-url team-popup-btn" href="javascript:void(0);">
                        <i class="flaticon-add"></i>
                    </a>                          
                </div>
            <?php } ?>

            <div class="content">
                <?php if ( !empty($name) ) { ?>
                    <h3 class="name-team">
                        <?php echo trim($name); ?>
                    </h3>
                <?php } ?>

                <?php if ( !empty($job) ) { ?>
                    <div class="job">
                        <?php echo trim($job); ?>
                    </div>
                <?php } ?>
            </div>
            <div class="hidden team-popup-wrapper">
                <div class="team-popup-inner">
                    <?php
                        if ( !empty($settings['img_src']['id']) ) {
                    ?>
                        <div class="team-image">
                            <?php echo abolire_get_attachment_thumbnail($settings['img_src']['id'], 'full'); ?>
                        </div>
                    <?php } ?>
                    <div class="content">
                        <?php if ( !empty($name) ) { ?>
                            <h2 class="name-team">
                                <?php echo trim($name); ?>
                            </h2>
                        <?php } ?>

                        <?php if ( !empty($job) ) { ?>
                            <div class="job text-theme">
                                <?php echo trim($job); ?>
                            </div>
                        <?php } ?>

                        <?php if ( !empty($description) ) { ?>
                            <div class="description">                            
                                <?php echo trim($description); ?>
                            </div>
                        <?php } ?>

                        <div class="contact-info">
                            <h4><?php esc_html_e('Contact:', 'abolire'); ?></h4>
                            <?php if ( !empty($email) ) { ?>
                                <div class="email">                            
                                    <a href="mailto:<?php echo trim($email); ?>" target="_top"><?php echo trim($email); ?></a>
                                </div>
                            <?php } ?>

                            <?php if ( !empty($phone) ) { ?>
                                <div class="phone">                            
                                    <a href="tel:<?php echo trim($phone); ?>"><?php echo trim($phone); ?></a>
                                </div>
                            <?php } ?>
                        </div>

                        <div class="social-info">
                            <h4><?php esc_html_e('Social Account:', 'abolire'); ?></h4>
                            <ul class="social list-inline">
                                <?php foreach ($socials as $social) { ?>
                                    <?php if ( !empty($social['link']) && !empty($social['icon']) ) { ?>
                                        <li>
                                            <a href="<?php echo esc_url($social['link']);?>" <?php echo trim(!empty($social['title']) ? 'title="'.$social['title'].'"' : ''); ?>>
                                                <i class="<?php echo esc_attr($social['icon']); ?>"></i>
                                            </a>
                                        </li>
                                    <?php } ?>
                                <?php } ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type( new Abolire_Elementor_Agents );