<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Abolire_Elementor_Team extends Widget_Base {

	public function get_name() {
        return 'apus_element_team';
    }

	public function get_title() {
        return esc_html__( 'Apus Teams', 'abolire' );
    }

    public function get_icon() {
        return 'fa fa-users';
    }

	public function get_categories() {
        return [ 'abolire-elements' ];
    }

	protected function _register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'Team', 'abolire' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new Repeater();

        $this->add_control(
            'name', [
                'label' => esc_html__( 'Member Name', 'abolire' ),
                'type' => Controls_Manager::TEXT,                
                'placeholder' => esc_html__( 'Member Name' , 'abolire' ),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'email', [
                'label' => esc_html__( 'Email', 'abolire' ),
                'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'info@mywebsite.com' , 'abolire' ),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'phone', [
                'label' => esc_html__( 'Phone', 'abolire' ),
                'type' => Controls_Manager::TEXT,                
                'placeholder' => esc_html__( '0123456789', 'abolire' ),
                'label_block' => true,
            ]
        );
        
        $this->add_control(
            'website_link',
            [
                'label' => esc_html__( 'Link Profile', 'abolire' ),
                'type' => Controls_Manager::URL,
                'placeholder' => esc_html__( 'https://your-link.com', 'abolire' ),
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );

        $this->add_control(
            'img_src',
            [
                'name' => 'image',
                'label' => esc_html__( 'Image', 'abolire' ),
                'type' => Controls_Manager::MEDIA,
                'placeholder'   => esc_html__( 'Upload Image Here', 'abolire' ),
            ]
        );

   		$this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'abolire' ),
                'type'          => Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'abolire' ),
            ]
        );

        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings();
        $target = $settings['website_link']['is_external'] ? ' target="_blank"' : '';
        $nofollow = $settings['website_link']['nofollow'] ? ' rel="nofollow"' : '';

        extract( $settings );

        ?>
        <div class="widget-team <?php echo esc_attr($el_class); ?> horizontal">

                <?php
                    if ( !empty($settings['img_src']['id']) ) {
                ?>
                    <div class="team-image">
                        <?php echo abolire_get_attachment_thumbnail($settings['img_src']['id'], 'full'); ?>
                    </div>
                <?php } ?>
                <div class="content">
                    <?php if ( !empty($name) ) { ?>
                        <h3 class="name-team">
                            <?php echo trim($name); ?>
                        </h3>
                    <?php } ?>

                    <?php if ( !empty($email) ) { ?>
                        <div class="email">                            
                            <a href="mailto:<?php echo trim($email); ?>" target="_top"><?php echo trim($email); ?></a>
                        </div>
                    <?php } ?>

                    <?php if ( !empty($phone) ) { ?>
                        <div class="phone">                            
                            <a href="tel:<?php echo trim($phone); ?>"><?php echo trim($phone); ?></a>
                        </div>
                    <?php } ?>
                </div>
        </div>
        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type( new Abolire_Elementor_Team );