<?php
global $post;
?>
<article <?php post_class(); ?>>	
	<?php if ( has_post_thumbnail() ) { ?>
		<div class="apartment-thumb">
			<a class="post-thumbnail" href="<?php the_permalink(); ?>" aria-hidden="true">
				<?php the_post_thumbnail( 'abolire-blog-grid', array( 'alt' => get_the_title() ) ); ?>
			</a>
			<a href="<?php echo esc_url(get_the_post_thumbnail_url($post)); ?>" class="apartment-up">
				<i class="flaticon-add"></i>
			</a>
		</div>
	<?php } ?>
	<div class="apartment-content-box">
		<?php the_title( '<h3 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h3>' ); ?>
		<?php if ( has_excerpt() ) { ?>
			<div class="description"><?php echo abolire_substring( get_the_excerpt(), 20, '...' ); ?></div>
		<?php } ?>	
	</div>
</article>