<?php
/**
 * Post Type: Private Apartment
 *
 * @package    apus-abolire
 * @author     Habq 
 * @license    GNU General Public License, version 3
 */

if ( ! defined( 'ABSPATH' ) ) {
  	exit;
}

class Apus_Abolire_Post_Type_Apartment {
	public static function init() {
	  	add_action( 'init', array( __CLASS__, 'register_post_type' ) );
	  	add_filter( 'cmb2_meta_boxes', array( __CLASS__, 'metaboxes' ) );
	}

	public static function register_post_type() {
		$labels = array(
			'name'                  => __( 'Apartments', 'apus-abolire' ),
			'singular_name'         => __( 'Apartment', 'apus-abolire' ),
			'add_new'               => __( 'Add New Apartment', 'apus-abolire' ),
			'add_new_item'          => __( 'Add New Apartment', 'apus-abolire' ),
			'edit_item'             => __( 'Edit Apartment', 'apus-abolire' ),
			'new_item'              => __( 'New Apartment', 'apus-abolire' ),
			'all_items'             => __( 'All Apartments', 'apus-abolire' ),
			'view_item'             => __( 'View Apartment', 'apus-abolire' ),
			'search_items'          => __( 'Search Apartment', 'apus-abolire' ),
			'not_found'             => __( 'No Apartments found', 'apus-abolire' ),
			'not_found_in_trash'    => __( 'No Apartments found in Trash', 'apus-abolire' ),
			'parent_item_colon'     => '',
			'menu_name'             => __( 'Apartments', 'apus-abolire' ),
		);
		
		register_post_type( 'apartment',
			array(
				'labels'            => $labels,
				'supports'          => array( 'title', 'editor', 'author', 'thumbnail', 'excerpt' ),
				'public'            => true,
		        'has_archive'       => true,
				'show_in_rest'		=> true,
				'menu_icon'         => 'dashicons-admin-post',
			)
		);
	}

	/**
	 *
	 */
	public static function metaboxes( array $metaboxes ) {
		$prefix = APUS_ABOLIRE_PREFIX;
		
		$metaboxes[ $prefix . 'info' ] = array(
			'id'                        => $prefix . 'info',
			'title'                     => __( 'More Information', 'apus-abolire' ),
			'object_types'              => array( 'apartment' ),
			'context'                   => 'normal',
			'priority'                  => 'high',
			'show_names'                => true,
			'fields'                    => self::metaboxes_info_fields()
		);
		
		return $metaboxes;
	}
	/**
	 *
	 */	
	public static function metaboxes_info_fields() {
		$prefix = APUS_ABOLIRE_PREFIX;

		$fields = array(
			array(
			    'name' => __( 'Address', 'apus-abolire' ),
			    'id' => $prefix.'address',
			    'type' => 'text',
			)
		);
		
		return apply_filters( 'apus_abolire_postype_apartment_metaboxes_fields' , $fields, $prefix );
	}
}
Apus_Abolire_Post_Type_Apartment::init();


